	function PLOT_PHASE_DELAY_FD(wT, phasedelay, Ncases, d, D)
	
	%	Plots the phase delay responses for a 
	%	fractional-delay filter. 
	%
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2016-05-04
	% 	Modified by: 	 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1 
	% 	Known bugs:		
	% 	Report bugs to:	larsw@isy.liu.se
	
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	
	for k = 1:Ncases
		plot(wT, phasedelay(k,:),'linewidth', 2); hold on
		text(0.15,d(k)+D+0.05,['d = ',num2str(d(k))]); % May need to be changed
		hold on
	end
	set(gca,'FontName', 'times','FontSize', 14);
	ylabel(['{\it\tau_f}({\ite^j^\omega^T})   [T]'],'FontName', fn,'FontSize',fs);
	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};
	xlabel('{\it\omegaT} [rad]');	
	xtick(ax,lab);
	hold off
	grid on
	
	
